
package easik.sketch.document;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import easik.Easik;


/**
 * Create a new User Interface for input of the document information.
 * 
 * <br>
 * Document information includes the name of the sketch, the authors of the sketch, a short description of the sketch,
 * and both the creation and last modification dates.  Users can manually edit the name of the sketch, the authors, and 
 * the description.  Creation date and last modification date are displayed, but are uneditable.
 * 
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @since 2006-07-14 Vera Ranieri
 * @version 2006-08-21 Kevin Green
 *
 */
public class DocInfoUI extends JDialog{
	/**
	 * The window's width
	 */
	private final int WINDOW_WIDTH = 500;
	/**
	 * The window's height
	 */
	private final int WINDOW_HEIGHT = 400;
	/**
	 * The window's x-position
	 */
	private final int WINDOW_POS_X = 300;
	/**
	 * The window's y-position
	 */
	private final int WINDOW_POS_Y = 250;
	
	/**
	 * The JTextField that records the name of this document
	 */
	private JTextField _name;
	/**
	 * The JTextField that records the authors of this document
	 */
	private JTextField _author;
	/**
	 * The JTextField that records the description of this document
	 */
	private JTextField _desc;
	/**
	 * The ok button
	 */
	private JButton _ok;
	/**
	 * The cancel button
	 */
	private JButton _cancel;
	/**
	 * The UI instance.  Used to allow for disposal.
	 */
	private DocInfoUI _diui = this;
	
	/**
	 * Create a new instance of the document information dialog box. 
	 *
	 */
	public DocInfoUI(){
		super();
		this.setSize(WINDOW_WIDTH, WINDOW_HEIGHT);
		this.setResizable(false);
		this.setTitle("Document Information");
		this.setBounds(WINDOW_POS_X, WINDOW_POS_Y, WINDOW_WIDTH, WINDOW_HEIGHT);
		createDialogBox();
		this.setModal(true);
		this.setVisible(true);
	}
	
	/**
	 * Adds all components to the document information dialog box.
	 */
	private void createDialogBox(){
		DocumentInfo d = Easik.getInstance().getFrame().getSketch().getDocInfo();
		JPanel infoBox = new JPanel(new BorderLayout());
		
		//Add the title
		
		JPanel title = new JPanel(new GridLayout(2, 1));
		title.add(new JLabel(""));
		title.add(new JLabel("Information about the current sketch", JLabel.CENTER));
		infoBox.add(title, BorderLayout.NORTH);
		
		//Add the name field
		JPanel infoPanel = new JPanel(new GridLayout(11, 1));
		infoPanel.add(new JLabel("Sketch Name"));
		
		_name = new JTextField();
		_name.setText(d.getName());
		_name.setEditable(true);
		infoPanel.add(_name);
		
		//Add the author field
		infoPanel.add(new JLabel("Authors (e.g. Author 1, Author 2, Author 3)"));
		_author = new JTextField();
		_author.setText(d.getAuthorString());
		_author.setEditable(true);
		infoPanel.add(_author);
		
		//Add the description field
		infoPanel.add(new JLabel("Description"));
		_desc = new JTextField();
		_desc.setText(d.getDesc());
		_desc.setEditable(true);
		infoPanel.add(_desc);
		
		//add the time info
		infoPanel.add(new JLabel("Date Created"));
		infoPanel.add(new JLabel("     " +d.getCreationDate()));
		
		infoPanel.add(new JLabel("Date Last Modified"));
		infoPanel.add(new JLabel("     " +d.getLastMod()));
		
		
		infoBox.add(infoPanel, BorderLayout.CENTER);
		
		//Padding to make it look nicer 
		//TODO: better way to do this
		JLabel w = new JLabel("              ");
		infoBox.add(w, BorderLayout.WEST);
		
		JLabel e = new JLabel("              ");
		infoBox.add(e, BorderLayout.EAST);

		//Add the buttons
		_ok = new JButton("OK");
		_ok.setSelected(true);
		
		_cancel = new JButton("Cancel");
		
		ButtonActionListener bal = new ButtonActionListener();
		_ok.addActionListener(bal);
		_cancel.addActionListener(bal);
		
		
		JPanel buttons = new JPanel(new GridLayout(1, 3));
		buttons.add(_ok);
		buttons.add(_cancel);
		
		infoBox.add(buttons, BorderLayout.SOUTH);
		infoBox.setVisible(true);
		
		this.getContentPane().add(infoBox);
		
		
	}
	
	/**
	 * The Action listener registered to the <b>OK</b> and <b>Cancel</b> buttons
	 * @author Vera Ranieri 2006
	 * @since 2006-07-18 Vera Ranieri
	 * @version 2006-07-18 Vera Ranieri
	 */
	private class ButtonActionListener implements ActionListener{
		
		/**
		 * Listens for when the 'ok' or 'cancel' button is pressed in the UI
		 * @param e The action event
		 */
		public void actionPerformed(ActionEvent e){
			if(e.getActionCommand().equals("OK")){
			
				Easik.getInstance().getFrame().getSketch()
						.getDocInfo().setAllInfo(_name.getText(), _author.getText(), _desc.getText());
				
			}
		
			_diui.dispose();
		}
		
	}	
}
